from visual import *
from visual.graph import *


class VisualGraph:
    def __init__(self, nSpinsX, nSpinsY):
        self.window = display(title='Angle Plot', width=400, height=400, x=15, y=15, center=(0,0,0), background=(.0,.0,.0))

        self.tvGraphs = 0
        
        self.angleCurveA = gcurve(color=color.red, visible=self.tvGraphs)
        self.angleCurveB = gcurve(color=color.green, visible=self.tvGraphs)
        self.angleCurveC = gcurve(color=color.blue, visible=self.tvGraphs)
##        self.angleCurveD = gcurve(color=color.white, visible=self.tvGraphs)

        self.nSpinsX = nSpinsX
        self.nSpinsY = nSpinsY

          
    def updateGraph(self,nLattice,t):
        spinArray = nLattice.returnState()
        energyArray = nLattice.returnEnergies()
        
        componentA = float(spinArray[0][0][0][0])
        componentB = float(spinArray[1][0][0][0])
        componentC = float(spinArray[2][0][0][0])
##        componentD = float(spinArray[0][0][0][0]-3.0*spinArray[1][0][0][0]+spinArray[2][0][0][0])

##        if abs(dotA) < 1.0:     diffAngleA = arccos(dotA)
##        else:                   diffAngleA = pi
##        if abs(dotB) < 1.0:     diffAngleB = arccos(dotB)
##        else:                   diffAngleB = pi
##        if abs(dotC) < 1.0:     diffAngleC = arccos(dotC)
##        else:                   diffAngleC = pi
               
        self.angleCurveA.plot(pos=(t,componentA))
        self.angleCurveB.plot(pos=(t,componentB))
        self.angleCurveC.plot(pos=(t,componentC))
##        self.angleCurveD.plot(pos=(t,componentD))

    def toggleGraph(self):
        self.tvGraphs = (self.tvGraphs+1)%2

        self.angleCurveA.visible = self.tvGraphs
        self.angleCurveB.visible = self.tvGraphs
        self.angleCurveC.visible = self.tvGraphs
##        self.angleCurveD.visible = self.tvGraphs

    def resetPlots(self):
        t = 0.000
        self.angleCurveA.gcurve.visible = 0
        self.angleCurveB.gcurve.visible = 0
        self.angleCurveC.gcurve.visible = 0
##        self.angleCurveD.gcurve.visible = 0

        self.angleCurveA = gcurve(color=color.red, visible=self.tvGraphs)
        self.angleCurveB = gcurve(color=color.green, visible=self.tvGraphs)
        self.angleCurveC = gcurve(color=color.blue, visible=self.tvGraphs)
##        self.angleCurveD = gcurve(color=color.white, visible=self.tvGraphs)
